#ifndef PLAYERCONTROL_HPP
#define PLAYERCONTROL_HPP

#include <QObject>

class PlayerControl: public QObject
{
    Q_OBJECT
  signals:
    void doStart();   void sayPlay();
    void doStop();    void sayStop();
    void doPause();   void sayPause();

  public slots:
    void playPause();
    void stop();

    void started();
    void stopped();
    void paused();

  public:
    PlayerControl();

  private:
    typedef enum {
      STOP,
      PAUSE,
      PLAY
    } Status;

    Status  mStatus = STOP;
};

#endif // PLAYERCONTROL_HPP
